/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.math.IntMath;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.DamageSourcePneumaticCraft;
import me.desht.pneumaticcraft.api.crafting.recipe.PressureChamberRecipe;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.api.tileentity.IAirListener;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.IBlockPressureChamber;
import me.desht.pneumaticcraft.common.block.PressureChamberGlassBlock;
import me.desht.pneumaticcraft.common.block.PressureChamberValveBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.block.entity.PressureChamberWallBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModRecipeTypes;
import me.desht.pneumaticcraft.common.inventory.PressureChamberValveMenu;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.util.CountedItemStacks;
import me.desht.pneumaticcraft.common.util.ItemStackHandlerIterable;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.SizeLimitedItemHandlerWrapper;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class PressureChamberValveBlockEntity
extends AbstractAirHandlingBlockEntity
implements IMinWorkingPressure,
IAirListener,
MenuProvider {
    private static final int CHAMBER_INV_SIZE = 18;
    private static final int OUTPUT_INV_SIZE = 9;
    @DescSynced
    public int multiBlockX;
    @DescSynced
    public int multiBlockY;
    @DescSynced
    public int multiBlockZ;
    @DescSynced
    public int multiBlockSize;
    @DescSynced
    public boolean hasGlass;
    @DescSynced
    private float roundedPressure;
    @GuiSynced
    public boolean isValidRecipeInChamber;
    @GuiSynced
    public boolean isSufficientPressureInChamber;
    @GuiSynced
    public float recipePressure;
    private final ItemStackHandler itemsInChamber = new ChamberStackHandler();
    final ItemStackHandler craftedItems = new OutputStackHandler();
    @DescSynced
    final CombinedInvWrapper allItems = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemsInChamber, this.craftedItems});
    public final List<ItemStack> renderedItems = new ArrayList<ItemStack>();
    public List<PressureChamberValveBlockEntity> accessoryValves;
    private final List<BlockPos> nbtValveList;
    private final List<ApplicableRecipe> applicableRecipes = new ArrayList<ApplicableRecipe>();
    private boolean recipeRecalcNeeded = true;
    private long lastSoundTick;
    private int nParticles;
    private boolean triedRebuild;
    private int savedMultiblockSize = 0;

    public PressureChamberValveBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.PRESSURE_CHAMBER_VALVE.get(), pos, state, PressureTier.TIER_ONE, 16000, 4);
        this.accessoryValves = new ArrayList<PressureChamberValveBlockEntity>();
        this.nbtValveList = new ArrayList<BlockPos>();
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side.m_122434_() == this.getRotation().m_122434_();
    }

    @Override
    public List<IAirHandlerMachine> addConnectedPneumatics(List<IAirHandlerMachine> airHandlers) {
        if (this.accessoryValves != null) {
            for (PressureChamberValveBlockEntity valve : this.accessoryValves) {
                if (valve == this) continue;
                airHandlers.add(valve.airHandler);
            }
        }
        return airHandlers;
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (this.hasGlass && this.isPrimaryValve() && (double)this.roundedPressure > 0.2 && ClientUtils.getClientPlayer().m_20275_((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_()) < 256.0) {
            Level level = this.nonNullLevel();
            for (int i = 0; i < this.nParticles; ++i) {
                double posX = (double)this.multiBlockX + 1.0 + level.f_46441_.nextDouble() * ((double)this.multiBlockSize - 2.0);
                double posY = (double)this.multiBlockY + 1.5 + level.f_46441_.nextDouble() * ((double)this.multiBlockSize - 2.5);
                double posZ = (double)this.multiBlockZ + 1.0 + level.f_46441_.nextDouble() * ((double)this.multiBlockSize - 2.0);
                level.m_7106_((ParticleOptions)AirParticleData.DENSE, posX, posY, posZ, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.checkForAirLeak();
        if (this.multiBlockSize != 0) {
            this.roundedPressure = (float)((int)(this.getPressure() * 4.0f)) / 4.0f;
            this.checkForRecipeRecalc();
            this.processApplicableRecipes();
            if (this.getPressure() > 1.0f) {
                this.handleEntitiesInChamber();
            }
        }
    }

    private void checkForRecipeRecalc() {
        if (this.recipeRecalcNeeded) {
            this.isValidRecipeInChamber = false;
            this.isSufficientPressureInChamber = false;
            this.recipePressure = Float.MAX_VALUE;
            this.applicableRecipes.clear();
            SizeLimitedItemHandlerWrapper h = new SizeLimitedItemHandlerWrapper((IItemHandler)this.itemsInChamber);
            if (h.getSlots() > 0) {
                ((PneumaticCraftRecipeType)ModRecipeTypes.PRESSURE_CHAMBER.get()).stream(this.f_58857_).forEach(recipe -> {
                    Collection<Integer> slots = recipe.findIngredients(h);
                    if (!slots.isEmpty()) {
                        this.applicableRecipes.add(new ApplicableRecipe((PressureChamberRecipe)recipe, slots));
                    }
                });
            }
            this.isValidRecipeInChamber = !this.applicableRecipes.isEmpty();
            this.recipeRecalcNeeded = !this.isValidRecipeInChamber && this.coalesceItems();
        }
    }

    private boolean coalesceItems() {
        CountedItemStacks count = new CountedItemStacks((IItemHandler)this.itemsInChamber);
        if (!count.canCoalesce()) {
            return false;
        }
        NonNullList<ItemStack> coalesced = count.coalesce();
        for (int i = 0; i < this.itemsInChamber.getSlots(); ++i) {
            if (i < coalesced.size()) {
                this.itemsInChamber.setStackInSlot(i, (ItemStack)coalesced.get(i));
                continue;
            }
            this.itemsInChamber.setStackInSlot(i, ItemStack.f_41583_);
        }
        return true;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.doPostNBTSetup();
    }

    private void doPostNBTSetup() {
        if (!this.nbtValveList.isEmpty()) {
            BlockState state = this.nonNullLevel().m_8055_(this.m_58899_());
            if (state.m_60734_() instanceof PressureChamberValveBlock) {
                this.nonNullLevel().m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)PressureChamberValveBlock.FORMED, (Comparable)Boolean.valueOf(this.isPrimaryValve())), 2);
            }
            this.accessoryValves.clear();
            for (BlockPos valve : this.nbtValveList) {
                BlockEntity te = this.nonNullLevel().m_7702_(valve);
                if (!(te instanceof PressureChamberValveBlockEntity)) continue;
                this.accessoryValves.add((PressureChamberValveBlockEntity)te);
            }
            if (this.isPrimaryValve()) {
                this.hasGlass = this.checkForGlass();
                this.sendDescriptionPacket();
            }
            this.nbtValveList.clear();
        }
    }

    private void checkForAirLeak() {
        PressureChamberValveBlockEntity primaryValve;
        BitSet disconnected = new BitSet(6);
        switch (this.getRotation().m_122434_()) {
            case X: {
                disconnected.set(Direction.WEST.m_122411_());
                disconnected.set(Direction.EAST.m_122411_());
                break;
            }
            case Y: {
                disconnected.set(Direction.UP.m_122411_());
                disconnected.set(Direction.DOWN.m_122411_());
                break;
            }
            case Z: {
                disconnected.set(Direction.NORTH.m_122411_());
                disconnected.set(Direction.SOUTH.m_122411_());
            }
        }
        List<IAirHandlerMachine.Connection> l = this.airHandler.getConnectedAirHandlers(this);
        for (IAirHandlerMachine.Connection c : l) {
            if (c.getDirection() == null) continue;
            disconnected.clear(c.getDirection().m_122411_());
        }
        if (this.accessoryValves.isEmpty() && !this.triedRebuild) {
            if (PressureChamberValveBlockEntity.checkIfProperlyFormed(this.f_58857_, this.f_58858_, true)) {
                Log.warning("Rebuilt damaged pressure chamber multiblock: valve pos = " + this.f_58858_, new Object[0]);
            }
            this.triedRebuild = true;
        }
        PressureChamberValveBlockEntity pressureChamberValveBlockEntity = primaryValve = this.accessoryValves.isEmpty() ? null : this.accessoryValves.get(this.accessoryValves.size() - 1);
        if (primaryValve != null) {
            switch (this.getRotation().m_122434_()) {
                case X: {
                    if (primaryValve.multiBlockX == this.m_58899_().m_123341_()) {
                        disconnected.clear(Direction.EAST.m_122411_());
                        break;
                    }
                    disconnected.clear(Direction.WEST.m_122411_());
                    break;
                }
                case Y: {
                    if (primaryValve.multiBlockY == this.m_58899_().m_123342_()) {
                        disconnected.clear(Direction.UP.m_122411_());
                        break;
                    }
                    disconnected.clear(Direction.DOWN.m_122411_());
                    break;
                }
                case Z: {
                    if (primaryValve.multiBlockZ == this.m_58899_().m_123343_()) {
                        disconnected.clear(Direction.SOUTH.m_122411_());
                        break;
                    }
                    disconnected.clear(Direction.NORTH.m_122411_());
                }
            }
        }
        this.airHandler.setSideLeaking(disconnected.isEmpty() ? null : this.getRotation());
    }

    private void processApplicableRecipes() {
        for (ApplicableRecipe applicableRecipe : this.applicableRecipes) {
            boolean pressureOK;
            PressureChamberRecipe recipe = applicableRecipe.recipe;
            float requiredPressure = recipe.getCraftingPressure((IItemHandler)this.itemsInChamber, applicableRecipe.slots);
            boolean bl = pressureOK = requiredPressure <= this.getPressure() && requiredPressure > 0.0f || requiredPressure >= this.getPressure() && requiredPressure < 0.0f;
            if (Math.abs(requiredPressure) < Math.abs(this.recipePressure)) {
                this.recipePressure = requiredPressure;
            }
            if (!pressureOK) continue;
            this.isSufficientPressureInChamber = true;
            if (!this.giveOutput(recipe.craftRecipe((IItemHandler)this.itemsInChamber, applicableRecipe.slots, true), true) || !this.giveOutput(recipe.craftRecipe((IItemHandler)this.itemsInChamber, applicableRecipe.slots, false), false) || this.nonNullLevel().m_46467_() - this.lastSoundTick <= 5L) break;
            this.nonNullLevel().m_5594_(null, this.m_58899_(), SoundEvents.f_11752_, SoundSource.BLOCKS, 0.7f, 0.8f);
            this.lastSoundTick = this.nonNullLevel().m_46467_();
            break;
        }
    }

    private void handleEntitiesInChamber() {
        AABB bbBox = new AABB((double)(this.multiBlockX + 1), (double)(this.multiBlockY + 1), (double)(this.multiBlockZ + 1), (double)(this.multiBlockX + this.multiBlockSize - 1), (double)(this.multiBlockY + this.multiBlockSize - 1), (double)(this.multiBlockZ + this.multiBlockSize - 1));
        List entities = this.nonNullLevel().m_45976_(LivingEntity.class, bbBox);
        for (LivingEntity entity : entities) {
            entity.m_6469_(DamageSourcePneumaticCraft.PRESSURE, (float)((int)((double)this.getPressure() * 2.0)));
        }
    }

    private boolean checkForGlass() {
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < this.multiBlockSize; ++x) {
            for (int y = 0; y < this.multiBlockSize; ++y) {
                for (int z = 0; z < this.multiBlockSize; ++z) {
                    mPos = mPos.m_122178_(this.multiBlockX + x, this.multiBlockY + y, this.multiBlockZ + z);
                    if (!(this.nonNullLevel().m_8055_((BlockPos)mPos).m_60734_() instanceof PressureChamberGlassBlock)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean giveOutput(NonNullList<ItemStack> stacks, boolean simulate) {
        if (stacks.isEmpty()) {
            return false;
        }
        for (ItemStack stack : stacks) {
            ItemStack result = ItemHandlerHelper.insertItem((IItemHandler)this.craftedItems, (ItemStack)(stack = stack.m_41777_()), (boolean)simulate);
            if (result.m_41619_()) continue;
            return false;
        }
        return true;
    }

    ItemStack insertItemToChamber(ItemStack stack) {
        return ItemHandlerHelper.insertItem((IItemHandler)this.itemsInChamber, (ItemStack)stack.m_41777_(), (boolean)false);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.setupMultiBlock(tag.m_128451_("multiBlockSize"), tag.m_128451_("multiBlockX"), tag.m_128451_("multiBlockY"), tag.m_128451_("multiBlockZ"));
        ItemStackHandler handler = new ItemStackHandler();
        handler.deserializeNBT(tag.m_128469_("itemsInChamber"));
        for (int i = 0; i < handler.getSlots() && i < 18; ++i) {
            this.itemsInChamber.setStackInSlot(i, handler.getStackInSlot(i));
        }
        ItemStackHandler outHandler = new ItemStackHandler();
        outHandler.deserializeNBT(tag.m_128469_("craftedItems"));
        for (int i = 0; i < outHandler.getSlots() && i < 9; ++i) {
            this.craftedItems.setStackInSlot(i, outHandler.getStackInSlot(i));
        }
        ListTag accList = tag.m_128437_("Valves", 10);
        this.nbtValveList.clear();
        for (int i = 0; i < accList.size(); ++i) {
            CompoundTag tagCompound = accList.m_128728_(i);
            this.nbtValveList.add(NbtUtils.m_129239_((CompoundTag)tagCompound));
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("multiBlockX", this.multiBlockX);
        tag.m_128405_("multiBlockY", this.multiBlockY);
        tag.m_128405_("multiBlockZ", this.multiBlockZ);
        tag.m_128405_("multiBlockSize", this.multiBlockSize);
        tag.m_128365_("itemsInChamber", (Tag)this.itemsInChamber.serializeNBT());
        tag.m_128365_("craftedItems", (Tag)this.craftedItems.serializeNBT());
        ListTag accList = this.accessoryValves.stream().map(valve -> NbtUtils.m_129224_((BlockPos)valve.m_58899_())).collect(Collectors.toCollection(ListTag::new));
        tag.m_128365_("Valves", (Tag)accList);
    }

    public void onMultiBlockBreak() {
        if (this.isPrimaryValve()) {
            Iterator<ItemStack> itemsInChamberIterator = new ItemStackHandlerIterable((IItemHandlerModifiable)this.allItems).iterator();
            while (itemsInChamberIterator.hasNext()) {
                ItemStack stack = itemsInChamberIterator.next();
                if (stack.m_41619_()) continue;
                this.dropItemOnGround(stack);
                itemsInChamberIterator.remove();
            }
            this.invalidateMultiBlock();
        }
    }

    private void dropItemOnGround(ItemStack stack) {
        PneumaticCraftUtils.dropItemOnGroundPrecisely(stack, this.m_58904_(), (double)this.multiBlockX + (double)this.multiBlockSize / 2.0, (double)this.multiBlockY + 1.0, (double)this.multiBlockZ + (double)this.multiBlockSize / 2.0);
    }

    private void invalidateMultiBlock() {
        for (int x = 0; x < this.multiBlockSize; ++x) {
            for (int y = 0; y < this.multiBlockSize; ++y) {
                for (int z = 0; z < this.multiBlockSize; ++z) {
                    BlockEntity te = this.nonNullLevel().m_7702_(new BlockPos(x + this.multiBlockX, y + this.multiBlockY, z + this.multiBlockZ));
                    if (!(te instanceof PressureChamberWallBlockEntity)) continue;
                    PressureChamberWallBlockEntity teWall = (PressureChamberWallBlockEntity)te;
                    teWall.setPrimaryValve(null);
                }
            }
        }
        if (this.accessoryValves != null) {
            for (PressureChamberValveBlockEntity valve : this.accessoryValves) {
                valve.savedMultiblockSize = valve.multiBlockSize;
                float pressure = valve.getPressure();
                valve.setupMultiBlock(0, 0, 0, 0);
                valve.airHandler.setPressure(pressure);
                if (valve != this) {
                    valve.accessoryValves.clear();
                    valve.sendDescriptionPacket();
                }
                valve.m_6596_();
            }
            this.accessoryValves.clear();
        }
        this.sendDescriptionPacket();
    }

    private void setupMultiBlock(int size, int baseX, int baseY, int baseZ) {
        this.multiBlockSize = size;
        this.multiBlockX = baseX;
        this.multiBlockY = baseY;
        this.multiBlockZ = baseZ;
        int vol = 16000;
        this.airHandler.setBaseVolume(this.multiBlockSize > 3 ? vol * IntMath.pow((int)(this.multiBlockSize - 2), (int)3) : vol);
    }

    @Override
    public void onDescUpdate() {
        super.onDescUpdate();
        this.nParticles = (int)(Math.min(1.0f, this.roundedPressure / this.getDangerPressure() * (float)(this.multiBlockSize - 2) * (float)(this.multiBlockSize - 2)) * 2.0f);
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    public static boolean checkIfProperlyFormed(Level world, BlockPos pos) {
        return PressureChamberValveBlockEntity.checkIfProperlyFormed(world, pos, false);
    }

    public static boolean checkIfProperlyFormed(Level world, BlockPos pos, boolean forceRebuild) {
        for (int i = 3; i < 6; ++i) {
            if (!PressureChamberValveBlockEntity.checkForShiftedCubeOfSize(i, world, pos, forceRebuild)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkForShiftedCubeOfSize(int size, Level world, BlockPos pos, boolean forceRebuild) {
        int baseX = pos.m_123341_();
        int baseY = pos.m_123342_();
        int baseZ = pos.m_123343_();
        BlockPos rebuildPos = forceRebuild ? pos : null;
        for (int wallX = 0; wallX < size; ++wallX) {
            for (int wallY = 0; wallY < size; ++wallY) {
                if (PressureChamberValveBlockEntity.checkForCubeOfSize(size, world, baseX, baseY - wallY, baseZ - wallX, rebuildPos)) {
                    return true;
                }
                if (PressureChamberValveBlockEntity.checkForCubeOfSize(size, world, baseX, baseY + wallY, baseZ + wallX, rebuildPos)) {
                    return true;
                }
                if (PressureChamberValveBlockEntity.checkForCubeOfSize(size, world, baseX - wallX, baseY - wallY, baseZ, rebuildPos)) {
                    return true;
                }
                if (PressureChamberValveBlockEntity.checkForCubeOfSize(size, world, baseX + wallX, baseY + wallY, baseZ, rebuildPos)) {
                    return true;
                }
                if (PressureChamberValveBlockEntity.checkForCubeOfSize(size, world, baseX - wallX, baseY, baseZ - wallY, rebuildPos)) {
                    return true;
                }
                if (PressureChamberValveBlockEntity.checkForCubeOfSize(size, world, baseX + wallX, baseY, baseZ + wallY, rebuildPos)) {
                    return true;
                }
                if (PressureChamberValveBlockEntity.checkForCubeOfSize(size, world, baseX - size + 1, baseY - wallY, baseZ - wallX, rebuildPos)) {
                    return true;
                }
                if (PressureChamberValveBlockEntity.checkForCubeOfSize(size, world, baseX - size + 1, baseY + wallY, baseZ + wallX, rebuildPos)) {
                    return true;
                }
                if (PressureChamberValveBlockEntity.checkForCubeOfSize(size, world, baseX - wallX, baseY - wallY, baseZ - size + 1, rebuildPos)) {
                    return true;
                }
                if (PressureChamberValveBlockEntity.checkForCubeOfSize(size, world, baseX + wallX, baseY + wallY, baseZ - size + 1, rebuildPos)) {
                    return true;
                }
                if (PressureChamberValveBlockEntity.checkForCubeOfSize(size, world, baseX - wallX, baseY - size + 1, baseZ - wallY, rebuildPos)) {
                    return true;
                }
                if (!PressureChamberValveBlockEntity.checkForCubeOfSize(size, world, baseX + wallX, baseY - size + 1, baseZ + wallY, rebuildPos)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkForCubeOfSize(int size, Level world, int baseX, int baseY, int baseZ, BlockPos rebuildPos) {
        ArrayList<PressureChamberValveBlockEntity> valveList = new ArrayList<PressureChamberValveBlockEntity>();
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                for (int z = 0; z < size; ++z) {
                    PressureChamberValveBlockEntity teV;
                    mPos = mPos.m_122178_(x + baseX, y + baseY, z + baseZ);
                    BlockState state = world.m_8055_((BlockPos)mPos);
                    if (x != 0 && x != size - 1 && y != 0 && y != size - 1 && z != 0 && z != size - 1) {
                        if (world.m_46859_((BlockPos)mPos)) continue;
                        return false;
                    }
                    if (!(state.m_60734_() instanceof IBlockPressureChamber)) {
                        return false;
                    }
                    if (state.m_60734_() instanceof PressureChamberValveBlock) {
                        boolean xMid = x != 0 && x != size - 1;
                        boolean yMid = y != 0 && y != size - 1;
                        boolean zMid = z != 0 && z != size - 1;
                        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
                        if (xMid && yMid && facing.m_122434_() == Direction.Axis.Z || xMid && zMid && facing.m_122434_() == Direction.Axis.Y || yMid && zMid && facing.m_122434_() == Direction.Axis.X) {
                            BlockEntity te = world.m_7702_((BlockPos)mPos);
                            if (!(te instanceof PressureChamberValveBlockEntity)) continue;
                            valveList.add((PressureChamberValveBlockEntity)te);
                            continue;
                        }
                        return false;
                    }
                    BlockEntity te = world.m_7702_((BlockPos)mPos);
                    if (!(te instanceof PressureChamberWallBlockEntity) || (teV = ((PressureChamberWallBlockEntity)te).getPrimaryValve()) == null || rebuildPos != null && rebuildPos.equals((Object)teV.m_58899_())) continue;
                    return false;
                }
            }
        }
        if (valveList.isEmpty()) {
            return false;
        }
        PressureChamberValveBlockEntity primaryValve = (PressureChamberValveBlockEntity)valveList.get(valveList.size() - 1);
        valveList.forEach(valve -> {
            valve.accessoryValves = new ArrayList<PressureChamberValveBlockEntity>(valveList);
        });
        float pressure = primaryValve.getPressure();
        primaryValve.setupMultiBlock(size, baseX, baseY, baseZ);
        if (primaryValve.savedMultiblockSize == primaryValve.multiBlockSize) {
            primaryValve.airHandler.setPressure(pressure);
        }
        primaryValve.savedMultiblockSize = 0;
        primaryValve.hasGlass = false;
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                for (int z = 0; z < size; ++z) {
                    BlockEntity te = world.m_7702_(new BlockPos(x + baseX, y + baseY, z + baseZ));
                    if (te instanceof PressureChamberWallBlockEntity) {
                        PressureChamberWallBlockEntity teWall = (PressureChamberWallBlockEntity)te;
                        teWall.setPrimaryValve(primaryValve);
                        if (world.m_8055_(te.m_58899_()).m_60734_() instanceof PressureChamberGlassBlock) {
                            primaryValve.hasGlass = true;
                        }
                    } else if (te instanceof PressureChamberValveBlockEntity) {
                        BlockState state = world.m_8055_(te.m_58899_());
                        world.m_7731_(te.m_58899_(), (BlockState)state.m_61124_((Property)PressureChamberValveBlock.FORMED, (Comparable)Boolean.valueOf(((PressureChamberValveBlockEntity)te).isPrimaryValve())), 2);
                    }
                    if (te == null) continue;
                    double dx = x == 0 ? -0.1 : 0.1;
                    double dz = z == 0 ? -0.1 : 0.1;
                    NetworkHandler.sendToAllTracking((Object)new PacketSpawnParticle((ParticleOptions)ParticleTypes.f_123759_, (double)te.m_58899_().m_123341_() + 0.5, (double)te.m_58899_().m_123342_() + 0.5, (double)te.m_58899_().m_123343_() + 0.5, dx, 0.3, dz, 5, 0.0, 0.0, 0.0), te);
                }
            }
        }
        primaryValve.captureEntityItemsInChamber();
        primaryValve.scheduleDescriptionPacket();
        primaryValve.m_6596_();
        return true;
    }

    private boolean isPrimaryValve() {
        return this.multiBlockSize > 0;
    }

    private AABB getChamberAABB() {
        return new AABB((double)this.multiBlockX, (double)this.multiBlockY, (double)this.multiBlockZ, (double)(this.multiBlockX + this.multiBlockSize), (double)(this.multiBlockY + this.multiBlockSize), (double)(this.multiBlockZ + this.multiBlockSize));
    }

    private void captureEntityItemsInChamber() {
        List items = this.nonNullLevel().m_6443_(ItemEntity.class, this.getChamberAABB(), EntitySelector.f_20402_);
        for (ItemEntity item : items) {
            ItemStack stack = item.m_32055_();
            ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)this.itemsInChamber, (ItemStack)stack, (boolean)false);
            if (excess.m_41619_()) {
                item.m_146870_();
                continue;
            }
            item.m_32045_(excess);
        }
    }

    public AABB getRenderBoundingBox() {
        return this.getChamberAABB();
    }

    @Override
    public float getMinWorkingPressure() {
        return this.isValidRecipeInChamber ? this.recipePressure : -3.4028235E38f;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new PressureChamberValveMenu(i, playerInventory, this.m_58899_());
    }

    private void rebuildRenderedItems() {
        this.renderedItems.clear();
        for (int i = 0; i < this.allItems.getSlots(); ++i) {
            if (this.allItems.getStackInSlot(i).m_41619_()) continue;
            this.renderedItems.add(this.allItems.getStackInSlot(i));
        }
    }

    private class ChamberStackHandler
    extends ItemStackHandler {
        ChamberStackHandler() {
            super(18);
        }

        protected void onContentsChanged(int slot) {
            PressureChamberValveBlockEntity.this.recipeRecalcNeeded = true;
            if (PressureChamberValveBlockEntity.this.f_58857_ != null && ((PressureChamberValveBlockEntity)PressureChamberValveBlockEntity.this).f_58857_.f_46443_) {
                PressureChamberValveBlockEntity.this.rebuildRenderedItems();
            }
            PressureChamberValveBlockEntity.this.m_6596_();
        }
    }

    private class OutputStackHandler
    extends ItemStackHandler {
        OutputStackHandler() {
            super(9);
        }

        protected void onContentsChanged(int slot) {
            if (PressureChamberValveBlockEntity.this.f_58857_ != null && ((PressureChamberValveBlockEntity)PressureChamberValveBlockEntity.this).f_58857_.f_46443_) {
                PressureChamberValveBlockEntity.this.rebuildRenderedItems();
            }
            PressureChamberValveBlockEntity.this.m_6596_();
        }
    }

    private static class ApplicableRecipe {
        final PressureChamberRecipe recipe;
        final List<Integer> slots;

        ApplicableRecipe(PressureChamberRecipe recipe, Collection<Integer> slots) {
            this.recipe = recipe;
            this.slots = ImmutableList.copyOf(slots);
        }
    }
}

